/*
 * Decompiled with CFR 0.152.
 */
package pregameclient;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ViewStartscreen
extends JFrame {
    private JPanel mainPanel;
    private JLabel greetingLabel;
    private JLabel sessionLabel;
    private JTextField codeField;
    private JButton startButton;

    public ViewStartscreen(ActionListener onValidStart) {
        this.setTitle("Schiffe Versenken");
        this.setDefaultCloseOperation(3);
        this.setSize(480, 240);
        this.setLocationRelativeTo(null);
        this.greetingLabel = new JLabel("Willkommen beim Spiel Schiffe Versenken!");
        this.greetingLabel.setFont(new Font("SansSerif", 1, 16));
        this.greetingLabel.setHorizontalAlignment(0);
        this.greetingLabel.setAlignmentX(0.5f);
        this.sessionLabel = new JLabel("Sessioncode eingeben (Nur Ziffern und 6-stellig):");
        this.sessionLabel.setFont(new Font("SansSerif", 0, 14));
        this.sessionLabel.setAlignmentX(0.5f);
        this.codeField = new JTextField();
        this.codeField.setMaximumSize(new Dimension(200, 30));
        this.codeField.setAlignmentX(0.5f);
        this.codeField.setHorizontalAlignment(0);
        this.startButton = new JButton("Spiel starten");
        this.startButton.setEnabled(false);
        this.startButton.setFont(new Font("SansSerif", 0, 14));
        this.startButton.setAlignmentX(0.5f);
        this.codeField.getDocument().addDocumentListener(new DocumentListener(){

            private void updateButton() {
                ViewStartscreen.this.startButton.setEnabled(ViewStartscreen.this.isValidSessionCode());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButton();
            }
        });
        this.startButton.addActionListener(e -> {
            if (this.isValidSessionCode()) {
                onValidStart.actionPerformed(new ActionEvent(this, 1001, this.getSessionCode()));
            } else {
                System.out.println("Fehler bei der Code eingabe");
            }
        });
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(this.greetingLabel);
        this.mainPanel.add(Box.createVerticalStrut(25));
        this.mainPanel.add(this.sessionLabel);
        this.mainPanel.add(Box.createVerticalStrut(8));
        this.mainPanel.add(this.codeField);
        this.mainPanel.add(Box.createVerticalStrut(20));
        this.mainPanel.add(this.startButton);
        this.add(this.mainPanel);
        this.setVisible(true);
    }

    public String getSessionCode() {
        return this.codeField.getText().trim();
    }

    public boolean isValidSessionCode() {
        String text = this.getSessionCode();
        return text.matches("\\d{6}");
    }
}

