/*
 * Decompiled with CFR 0.152.
 */
package pregameclient;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mainclient.Response;
import pregameclient.PlacedShip;
import pregameclient.Ship;

public class ModelPregame {
    public static final int BOARD_SIZE = 10;
    private int[][] gameBoard;
    private List<PlacedShip> placedShips;
    private Random random = new Random();

    public ModelPregame() {
        this.gameBoard = new int[10][10];
        this.placedShips = new ArrayList<PlacedShip>();
    }

    public int[][] getBoardState() {
        return this.gameBoard;
    }

    public List<PlacedShip> getShipsList() {
        return new ArrayList<PlacedShip>(this.placedShips);
    }

    public boolean isValidPlacement(int r, int c, int size, boolean isHorizontal) {
        int i = 0;
        while (i < size) {
            int currentC;
            int currentR = isHorizontal ? r : r + i;
            int n = currentC = isHorizontal ? c + i : c;
            if (currentR < 0 || currentR >= 10 || currentC < 0 || currentC >= 10) {
                return false;
            }
            if (this.gameBoard[currentR][currentC] != 0) {
                return false;
            }
            ++i;
        }
        boolean allCellsInOuterRing = true;
        int i2 = 0;
        while (i2 < size) {
            boolean isInInnerArea;
            int currentR = isHorizontal ? r : r + i2;
            int currentC = isHorizontal ? c + i2 : c;
            boolean bl = isInInnerArea = currentR > 0 && currentR < 9 && currentC > 0 && currentC < 9;
            if (isInInnerArea) {
                allCellsInOuterRing = false;
                break;
            }
            ++i2;
        }
        if (allCellsInOuterRing) {
            return false;
        }
        i2 = 0;
        while (i2 < size) {
            int shipCellR = isHorizontal ? r : r + i2;
            int shipCellC = isHorizontal ? c + i2 : c;
            int dr = -1;
            while (dr <= 1) {
                int dc = -1;
                while (dc <= 1) {
                    if (dr != 0 || dc != 0) {
                        int checkR = shipCellR + dr;
                        int checkC = shipCellC + dc;
                        if (checkR >= 0 && checkR < 10 && checkC >= 0 && checkC < 10 && this.gameBoard[checkR][checkC] == 1) {
                            return false;
                        }
                    }
                    ++dc;
                }
                ++dr;
            }
            ++i2;
        }
        return true;
    }

    public PlacedShip execPlaceShip(int r, int c, int size, boolean isHorizontal) {
        PlacedShip newShip = new PlacedShip(r, c, size, isHorizontal);
        this.placedShips.add(newShip);
        for (Point cell : newShip.getCellPoints()) {
            this.gameBoard[cell.x][cell.y] = 1;
        }
        this.calcBufferZone(newShip);
        return newShip;
    }

    private void calcBufferZone(PlacedShip ship) {
        for (Point cell : ship.getCellPoints()) {
            int dr = -1;
            while (dr <= 1) {
                int dc = -1;
                while (dc <= 1) {
                    int bufferR = cell.x + dr;
                    int bufferC = cell.y + dc;
                    if (bufferR >= 0 && bufferR < 10 && bufferC >= 0 && bufferC < 10 && this.gameBoard[bufferR][bufferC] == 0) {
                        this.gameBoard[bufferR][bufferC] = 2;
                    }
                    ++dc;
                }
                ++dr;
            }
        }
    }

    public PlacedShip getShipAtPos(int r, int c) {
        for (PlacedShip ship : this.placedShips) {
            if (!ship.hasCellAt(r, c)) continue;
            return ship;
        }
        return null;
    }

    public void execRemoveShip(PlacedShip shipToRemove) {
        if (shipToRemove == null || !this.placedShips.contains(shipToRemove)) {
            return;
        }
        for (Point cell : shipToRemove.getCellPoints()) {
            this.gameBoard[cell.x][cell.y] = 0;
        }
        this.placedShips.remove(shipToRemove);
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                if (this.gameBoard[i][j] == 2) {
                    this.gameBoard[i][j] = 0;
                }
                ++j;
            }
            ++i;
        }
        for (PlacedShip ship : this.placedShips) {
            this.calcBufferZone(ship);
        }
    }

    public void resetBoard() {
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                this.gameBoard[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.placedShips.clear();
    }

    public boolean execPlaceRand() {
        this.resetBoard();
        Ship.resetAllCounts();
        int[] shipSizesToPlace = new int[]{4, 3, 3, 2, 2, 2, 1, 1, 1, 1};
        return this.placeShipsRandom(shipSizesToPlace, 0);
    }

    private boolean placeShipsRandom(int[] shipSizes, int index) {
        if (index >= shipSizes.length) {
            return true;
        }
        int size = shipSizes[index];
        int attempts = 0;
        int maxAttempts = 200;
        while (attempts < maxAttempts) {
            boolean isHorizontal;
            int c;
            int r = this.random.nextInt(10);
            if (this.isValidPlacement(r, c = this.random.nextInt(10), size, isHorizontal = this.random.nextBoolean())) {
                this.execPlaceShip(r, c, size, isHorizontal);
                if (this.placeShipsRandom(shipSizes, index + 1)) {
                    return true;
                }
                this.resetBoard();
                Ship.resetAllCounts();
                return this.execPlaceRand();
            }
            ++attempts;
        }
        this.resetBoard();
        Ship.resetAllCounts();
        return this.execPlaceRand();
    }

    public Response handleResponse(String response) {
        String[] responseMSG = response.split(";");
        if (responseMSG[0].equals("cha")) {
            return new Response(responseMSG[0], responseMSG[1] + "\n");
        }
        if (responseMSG[0].equals("sta")) {
            return new Response(responseMSG[0], null);
        }
        if (responseMSG[0].equals("no session")) {
            return new Response("sess", "false");
        }
        return null;
    }
}

