/*
 * Decompiled with CFR 0.152.
 */
package pregameclient;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mainclient.Client;
import mainclient.MessageListener;
import mainclient.Response;
import pregameclient.ModelPregame;
import pregameclient.PlacedShip;
import pregameclient.Ship;
import pregameclient.ViewPregame;

public class ControllerPregame
implements MessageListener {
    public ViewPregame view;
    public ModelPregame model;
    Client main;
    boolean sessReady = false;
    private int selShipSize = 0;

    public ControllerPregame(ViewPregame v, Client c) {
        this.view = v;
        this.main = c;
        this.model = new ModelPregame();
        this.initListeners();
        this.updAllCntLbls();
        this.updShipBtnEn();
        this.updBoardDisp();
    }

    void initListeners() {
        this.main.getCom().setMessageListener(this);
        this.view.btnPlaceShip1.addActionListener(e -> this.setShipSize(1, this.view.btnPlaceShip1));
        this.view.btnPlaceShip2.addActionListener(e -> this.setShipSize(2, this.view.btnPlaceShip2));
        this.view.btnPlaceShip3.addActionListener(e -> this.setShipSize(3, this.view.btnPlaceShip3));
        this.view.btnPlaceShip4.addActionListener(e -> this.setShipSize(4, this.view.btnPlaceShip4));
        int r = 0;
        while (r < 10) {
            int c = 0;
            while (c < 10) {
                int finalR = r;
                int finalC = c;
                this.view.board[r][c].addActionListener(e -> this.onBoardClick(finalR, finalC));
                ++c;
            }
            ++r;
        }
        this.view.btnRemoveAll.addActionListener(e -> this.clearAllShips());
        this.view.randomBoardButton.addActionListener(e -> this.placeShipsRand());
        this.view.startButton.addActionListener(e -> this.startGameProc());
        this.view.chatEnterButton.addActionListener(e -> {
            this.main.getCom().submitRequest("cha;" + this.view.chatMsgTextArea.getText());
            this.view.chatMsgTextArea.setText("");
        });
        this.view.chatMsgTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ControllerPregame.this.view.chatMsgTextArea.getText().equals("Nachricht eingeben...")) {
                    ControllerPregame.this.view.chatMsgTextArea.setText("");
                    ControllerPregame.this.view.chatMsgTextArea.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ControllerPregame.this.view.chatMsgTextArea.getText().isEmpty()) {
                    ControllerPregame.this.view.chatMsgTextArea.setText("Nachricht eingeben...");
                    ControllerPregame.this.view.chatMsgTextArea.setForeground(Color.GRAY);
                }
            }
        });
        InputMap inputMap = this.view.chatMsgTextArea.getInputMap(0);
        ActionMap actionMap = this.view.chatMsgTextArea.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "sendMessage");
        actionMap.put("sendMessage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = ControllerPregame.this.view.chatMsgTextArea.getText().trim();
                if (!msg.isEmpty() && !msg.equals("Nachricht eingeben...")) {
                    ControllerPregame.this.main.getCom().submitRequest("cha;" + msg);
                    ControllerPregame.this.view.chatMsgTextArea.setText("");
                }
            }
        });
    }

    private void setShipSize(int size, JButton clickedButton) {
        if (Ship.getCount(size) > 0) {
            this.selShipSize = size;
            this.view.infoLabel.setText("Platziere ein " + size + "er Schiff. Klicke in das Spielfeld.");
        } else {
            this.view.infoLabel.setText("Keine " + size + "er Schiffe mehr verf\u00fcgbar.");
            this.selShipSize = 0;
        }
    }

    private void onBoardClick(int r, int c) {
        PlacedShip shipAtLocation = this.model.getShipAtPos(r, c);
        if (shipAtLocation != null) {
            int removedShipSize = shipAtLocation.getSize();
            this.model.execRemoveShip(shipAtLocation);
            Ship.incCount(removedShipSize);
            this.updBoardDisp();
            this.updShipCntLbl(removedShipSize);
            this.updShipBtnEn();
            this.view.infoLabel.setText(removedShipSize + "er Schiff entfernt.");
            this.selShipSize = 0;
        } else if (this.selShipSize > 0) {
            if (Ship.getCount(this.selShipSize) <= 0) {
                this.view.infoLabel.setText("Keine Schiffe der Gr\u00f6\u00dfe " + this.selShipSize + " mehr verf\u00fcgbar.");
                this.selShipSize = 0;
                return;
            }
            boolean isHorizontal = this.view.orientationCheckBox.isSelected();
            if (this.model.isValidPlacement(r, c, this.selShipSize, isHorizontal)) {
                this.model.execPlaceShip(r, c, this.selShipSize, isHorizontal);
                Ship.decCount(this.selShipSize);
                this.updBoardDisp();
                this.updShipCntLbl(this.selShipSize);
                this.updShipBtnEn();
                this.view.infoLabel.setText(this.selShipSize + "er Schiff platziert.");
                if (Ship.getCount(this.selShipSize) == 0) {
                    this.selShipSize = 0;
                }
            } else {
                this.view.infoLabel.setText("Schiff kann hier nicht platziert werden.");
            }
        } else {
            this.view.infoLabel.setText("W\u00e4hle einen Schiffstyp oder klicke auf ein Schiff zum Entfernen.");
        }
    }

    private void updBoardDisp() {
        int[][] boardState = this.model.getBoardState();
        int r_idx = 0;
        while (r_idx < 10) {
            int c_idx = 0;
            while (c_idx < 10) {
                if (boardState[r_idx][c_idx] == 1) {
                    this.view.board[r_idx][c_idx].setBackground(Color.LIGHT_GRAY);
                } else {
                    this.view.board[r_idx][c_idx].setBackground(Color.BLUE);
                }
                ++c_idx;
            }
            ++r_idx;
        }
    }

    private void updShipCntLbl(int size) {
        switch (size) {
            case 1: {
                this.view.place1Label.setText("Noch " + Ship.getShip1() + " 1er");
                break;
            }
            case 2: {
                this.view.place2Label.setText("Noch " + Ship.getShip2() + " 2er");
                break;
            }
            case 3: {
                this.view.place3Label.setText("Noch " + Ship.getShip3() + " 3er");
                break;
            }
            case 4: {
                this.view.place4Label.setText("Noch " + Ship.getShip4() + " 4er");
            }
        }
    }

    private void updAllCntLbls() {
        this.updShipCntLbl(1);
        this.updShipCntLbl(2);
        this.updShipCntLbl(3);
        this.updShipCntLbl(4);
    }

    private void updShipBtnEn() {
        this.view.btnPlaceShip1.setEnabled(Ship.getShip1() > 0);
        this.view.btnPlaceShip2.setEnabled(Ship.getShip2() > 0);
        this.view.btnPlaceShip3.setEnabled(Ship.getShip3() > 0);
        this.view.btnPlaceShip4.setEnabled(Ship.getShip4() > 0);
    }

    private void clearAllShips() {
        this.model.resetBoard();
        Ship.resetAllCounts();
        this.updBoardDisp();
        this.updAllCntLbls();
        this.updShipBtnEn();
        this.selShipSize = 0;
        this.view.infoLabel.setText("Alle Schiffe entfernt. Platziere deine Schiffe neu.");
    }

    private void placeShipsRand() {
        if (this.model.execPlaceRand()) {
            Ship.resetAllCounts();
            for (PlacedShip ship : this.model.getShipsList()) {
                Ship.decCount(ship.getSize());
            }
            this.updBoardDisp();
            this.updAllCntLbls();
            this.updShipBtnEn();
            this.view.infoLabel.setText("Schiffe zuf\u00e4llig platziert.");
        }
        this.selShipSize = 0;
    }

    public String formatBoardState(int[][] board) {
        StringBuilder sb = new StringBuilder();
        int[][] nArray = board;
        int n = board.length;
        int n2 = 0;
        while (n2 < n) {
            int[] row;
            int[] nArray2 = row = nArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                int cell = nArray2[n4];
                sb.append(cell).append(",");
                ++n4;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("|");
            ++n2;
        }
        return sb.toString();
    }

    private void startGameProc() {
        if (Ship.getShip1() == 0 && Ship.getShip2() == 0 && Ship.getShip3() == 0 && Ship.getShip4() == 0) {
            this.view.infoLabel.setText("Spiel wird gestartet...");
            String boardState = this.formatBoardState(this.model.getBoardState());
            if (this.sessReady) {
                this.view.dispose();
                this.main.startGame();
            }
            this.sessReady = true;
            this.main.com.sendBoardState(boardState);
        } else {
            this.view.infoLabel.setText("Bitte platziere zuerst alle Schiffe vollst\u00e4ndig!");
        }
    }

    @Override
    public void receiveMsg(String msg) {
        block13: {
            Response action = this.model.handleResponse(msg);
            if (action == null) break block13;
            switch (action.getTag()) {
                case "cha": {
                    SwingUtilities.invokeLater(() -> this.view.chatContentTextArea.append(action.getContent()));
                    break;
                }
                case "sta": {
                    this.sessReady = true;
                    break;
                }
                case "sess": {
                    SwingUtilities.invokeLater(() -> {
                        this.sessReady = false;
                        JOptionPane.showMessageDialog(null, "Gegner ist noch nicht beigetreten.", "Fehler", 0);
                    });
                }
            }
        }
    }
}

