/*
 * Decompiled with CFR 0.152.
 */
package mainclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mainclient.MessageListener;

public class ClientCom {
    private Socket sock;
    private PrintWriter serverOut;
    private BufferedReader serverIn;
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private boolean debugMode;
    private MessageListener listener;

    public ClientCom(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void contactServer() {
        String host = "ol-fbbug6.hs-woe.de";
        if (host.equals("")) {
            host = "localhost";
        }
        try {
            this.sock = new Socket(host, 65430);
            this.serverOut = new PrintWriter(this.sock.getOutputStream(), true);
            this.serverIn = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        }
        catch (UnknownHostException ex) {
            System.err.println("Host unbekannt");
            System.exit(-1);
        }
        catch (IOException ex) {
            System.err.println("Server nicht an Port 65430 verf\ufffdgbar");
            System.exit(-1);
        }
        System.out.println("Verbindung zu Server wurde hergestellt ...");
        this.startListening();
    }

    public void submitRequest(String request) {
        System.out.println(request + " von ClientCom an MyServer gesendet.");
        this.serverOut.println(request);
    }

    public synchronized void sendBoardState(String boardState) {
        this.submitRequest("board;" + boardState);
    }

    void startListening() {
        System.out.println("startListening() aufgerufen (Thread: " + Thread.currentThread().getName() + ")");
        new Thread(() -> {
            try {
                String line;
                while ((line = this.serverIn.readLine()) != null) {
                    System.out.println("Nachricht empfangen: " + line);
                    if (this.listener != null) {
                        this.listener.receiveMsg(line);
                        continue;
                    }
                    System.err.println("Kein MessageListener registriert!");
                }
                System.err.println("Socket geschlossen");
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Session seitens des Servers beendet.", "Fehler", 0));
            }
            catch (IOException e) {
                System.err.println("fehler bei listener");
            }
        }).start();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setMessageListener(MessageListener ml) {
        this.listener = ml;
    }
}

