/*
 * Decompiled with CFR 0.152.
 */
package mainclient;

import gameclient.ControllerGame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mainclient.ClientCom;
import pregameclient.ControllerPregame;
import pregameclient.ViewPregame;
import pregameclient.ViewStartscreen;

public class Client {
    public ClientCom com;
    ViewPregame pview;
    ControllerPregame pcontroller;
    ViewStartscreen startScreen;

    public Client(boolean debugMode) {
        this.com = new ClientCom(debugMode);
    }

    public ClientCom getCom() {
        return this.com;
    }

    public void startGame() {
        int[][] finalPlayerBoard = this.pcontroller.model.getBoardState();
        new ControllerGame(this.com, finalPlayerBoard);
    }

    public static void main(String[] args) {
        boolean debugMode = false;
        if (debugMode) {
            System.out.println("Debug-Modus aktiviert");
            Client c = new Client(true);
            c.pview = new ViewPregame();
            c.pcontroller = new ControllerPregame(c.pview, c);
            c.com.contactServer();
            c.com.submitRequest("mode;debug");
        } else {
            System.out.println("Debug-Modus deaktiviert");
            SwingUtilities.invokeLater(() -> {
                Client client = new Client(false);
                client.com.contactServer();
                client.startScreen = new ViewStartscreen(e -> {
                    String sessionCode = e.getActionCommand();
                    System.out.println("Eingegebener Code: " + sessionCode);
                    client.com.submitRequest("validate_session;" + sessionCode);
                });
                client.com.setMessageListener(msg -> {
                    if (msg.startsWith("validation_ok")) {
                        SwingUtilities.invokeLater(() -> {
                            client.startScreen.dispose();
                            Client.startPregame(client);
                        });
                    } else if (msg.startsWith("validation_failed") || msg.startsWith("already_started")) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(client.startScreen, "Ung\u00fcltiger Sessioncode. Bitte erneut versuchen.", "Fehler", 0));
                    }
                });
            });
        }
    }

    private static void startPregame(Client c) {
        c.pview = new ViewPregame();
        c.pcontroller = new ControllerPregame(c.pview, c);
    }
}

