/*
 * Decompiled with CFR 0.152.
 */
package gameclient;

import gameclient.EndWindow;
import gameclient.ModelGame;
import gameclient.ViewGame;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mainclient.ClientCom;
import mainclient.MessageListener;
import mainclient.Response;

public class ControllerGame
implements MessageListener {
    ClientCom com;
    public ViewGame view;
    public ModelGame model;

    public ControllerGame() {
    }

    public ControllerGame(ViewGame v, ClientCom c) {
        this.view = v;
        this.com = c;
        this.model = new ModelGame();
        this.addListeners();
    }

    public ControllerGame(ClientCom c, int[][] pregameBoard) {
        this.view = new ViewGame(pregameBoard);
        this.com = c;
        this.model = new ModelGame();
        this.addListeners();
    }

    public void addListeners() {
        this.com.setMessageListener(this);
        this.view.chatMsgTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ControllerGame.this.view.chatMsgTextArea.getText().equals("Nachricht eingeben...")) {
                    ControllerGame.this.view.chatMsgTextArea.setText("");
                    ControllerGame.this.view.chatMsgTextArea.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ControllerGame.this.view.chatMsgTextArea.getText().isEmpty()) {
                    ControllerGame.this.view.chatMsgTextArea.setText("Nachricht eingeben...");
                    ControllerGame.this.view.chatMsgTextArea.setForeground(Color.GRAY);
                }
            }
        });
        String[] zeilen = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        String[] spalten = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                int i2 = i;
                int j2 = j;
                this.view.oppBoardButtons[i][j].addActionListener(e -> this.view.targetLabel.setText("anvisiert: " + spalten[j2] + zeilen[i2]));
                ++j;
            }
            ++i;
        }
        this.view.confirmButton.addActionListener(e -> {
            String[] split = this.view.targetLabel.getText().split("\\s");
            String target = split[1];
            this.view.stopViewCd();
            this.model.stopModelCd();
            this.com.submitRequest("sho;" + target);
        });
        this.view.chatEnterButton.addActionListener(e -> {
            this.com.submitRequest("cha;" + this.view.chatMsgTextArea.getText());
            this.view.chatMsgTextArea.setText("");
        });
        InputMap inputMap = this.view.chatMsgTextArea.getInputMap(0);
        ActionMap actionMap = this.view.chatMsgTextArea.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "sendMessage");
        actionMap.put("sendMessage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = ControllerGame.this.view.chatMsgTextArea.getText().trim();
                if (!msg.isEmpty() && !msg.equals("Nachricht eingeben...")) {
                    ControllerGame.this.com.submitRequest("cha;" + msg);
                    ControllerGame.this.view.chatMsgTextArea.setText("");
                }
            }
        });
    }

    @Override
    public void receiveMsg(String msg) {
        block34: {
            Response action = this.model.handleResponse(msg);
            System.out.println(msg);
            if (action == null) break block34;
            switch (action.getTag()) {
                case "cha": {
                    SwingUtilities.invokeLater(() -> this.view.chatContentTextArea.append(action.getContent()));
                    break;
                }
                case "tur": {
                    SwingUtilities.invokeLater(() -> {
                        this.view.stopViewCd();
                        this.model.stopModelCd();
                        this.view.turnLabel.setText(action.getContent());
                        this.view.startViewCd();
                        if (this.view.turnLabel.getText().contains("Du")) {
                            this.model.startModelCd(() -> this.handleTimeout());
                        }
                    });
                    break;
                }
                case "sho1": {
                    String[] content1 = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        this.view.turnTimer.stop();
                        this.model.turnTimer.cancel();
                        this.view.chatContentTextArea.append(content1[0]);
                        this.view.oppBoardButtons[Integer.valueOf(content1[1])][Integer.valueOf(content1[2])].setBackground(Color.BLACK);
                        this.view.startViewCd();
                        if (this.view.turnLabel.getText().contains("Du")) {
                            this.model.startModelCd(() -> this.handleTimeout());
                        }
                    });
                    break;
                }
                case "sho2": {
                    String[] content2 = action.getContent().split(";");
                    System.out.println(action.getContent());
                    SwingUtilities.invokeLater(() -> {
                        this.view.chatContentTextArea.append(content2[0]);
                        this.view.oppBoardButtons[Integer.valueOf(content2[1])][Integer.valueOf(content2[2])].setBackground(Color.WHITE);
                    });
                    break;
                }
                case "sho3": {
                    String[] content3 = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        this.view.turnTimer.stop();
                        this.view.chatContentTextArea.append(content3[0]);
                        this.view.myBoardLabels[Integer.valueOf(content3[1])][Integer.valueOf(content3[2])].setBackground(Color.RED);
                        this.view.startViewCd();
                        if (this.view.turnLabel.getText().contains("Du")) {
                            this.model.startModelCd(() -> this.handleTimeout());
                        }
                    });
                    break;
                }
                case "sho4": {
                    String[] content4 = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        this.view.chatContentTextArea.append(content4[0]);
                        this.view.myBoardLabels[Integer.valueOf(content4[1])][Integer.valueOf(content4[2])].setBackground(Color.YELLOW);
                    });
                    break;
                }
                case "sho5": {
                    SwingUtilities.invokeLater(() -> this.view.chatContentTextArea.append(action.getContent()));
                    break;
                }
                case "sta": {
                    String[] contentS = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        this.view.oppLabel.setText("vs " + contentS[0]);
                        this.view.turnLabel.setText(contentS[1]);
                        this.view.startViewCd();
                        if (this.view.turnLabel.getText().contains("Du")) {
                            this.model.startModelCd(() -> this.handleTimeout());
                        }
                    });
                    break;
                }
                case "win": {
                    String[] contentw = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        System.out.println(contentw[1] + contentw[2]);
                        this.view.oppBoardButtons[Integer.valueOf(contentw[1])][Integer.valueOf(contentw[2])].setBackground(Color.BLACK);
                        this.view.chatContentTextArea.append(contentw[0]);
                        this.view.turnTimer.stop();
                        this.model.turnTimer.cancel();
                        EndWindow endw = new EndWindow("Gl\u00fcckwunsch! Du hast gewonnen!", "Neue Elo: " + contentw[4] + "(+" + contentw[3] + ")", Color.GREEN);
                        endw.setVisible(true);
                    });
                    break;
                }
                case "los": {
                    String[] contentl = action.getContent().split(";");
                    SwingUtilities.invokeLater(() -> {
                        this.view.myBoardLabels[Integer.valueOf(contentl[1])][Integer.valueOf(contentl[2])].setBackground(Color.RED);
                        this.view.chatContentTextArea.append(contentl[0]);
                        this.view.turnTimer.stop();
                        EndWindow endl = new EndWindow("Du wurdest besiegt!", "Neue Elo: " + contentl[4] + "(+" + contentl[3] + ")", Color.RED);
                        endl.setVisible(true);
                    });
                    break;
                }
            }
        }
    }

    void handleTimeout() {
        this.com.submitRequest("tim;");
    }
}

